.ifndef __MEMORY__
.define __MEMORY__

.struct _resolutionDependencies
	extendedHeight db
	introTextScroll db
	objectToSpriteYOffset db
	openingFirstDepackedLine dw
	openingFirstVramLine dw
	openingScroll db
	nameTableBegining dw
	verticalScrollEnd db
.endst

.ramsection "globals" slot 2
	;psgainden decompressor values	
	tileDecompVramPtr dw
	tileDecompBuffer dsb 32
	
	waitingForVBlank db
	frameCounter db
	random db
	
	;game status
	difficult db
	numEtanks db
	bossesBeaten db
	itens db
	numLifes db
	
	;scrolls
	horizontalScroll dw
	verticalScroll dw
	
	;controls
	holdedKeys db
	holdedKeysPrevious db
	pressedKeys db
	pauseButtonPressed db
	readControlsFunction dw  
	
	;vdp misc registers values
	vdpMisc1Value db
	vdpMisc2Value db
	
	resolutionDependencies instanceOf _resolutionDependencies
	
	;PSG Stuff
	; fundamental vars
	PSGMusicStatus             db    ; are we playing a background music?
	PSGMusicStart              dw    ; the pointer to the beginning of music
	PSGMusicPointer            dw    ; the pointer to the current
	PSGMusicLoopPoint          dw    ; the pointer to the loop begin
	PSGMusicSkipFrames         db    ; the frames we need to skip
	PSGLoopFlag                db    ; the tune should loop or not (flag)
	PSGMusicLastLatch          db    ; the last PSG music latch
	; decompression vars
	PSGMusicSubstringLen       db    ; lenght of the substring we are playing
	PSGMusicSubstringRetAddr   dw    ; return to this address when substring is over
	; ******* SFX *************
	; command buffering for channels 2-3
	PSGChan2Volume             db       ; the volume for channel 2
	PSGChan3Volume             db       ; the volume for channel 3
	PSGChan2LowTone            db       ; the low tone bits for channels 2
	PSGChan3LowTone            db       ; the low tone bits for channels 3
	PSGChan2HighTone           db       ; the high tone bits for channel 2
	; flags for channels 2-3 access
	PSGChannel2SFX             db       ; !0 means channel 2 is allocated to SFX
	PSGChannel3SFX             db       ; !0 means channel 3 is allocated to SFX
	; fundamental vars for SFX
	PSGSFXStatus               db       ; are we playing a SFX?
	PSGSFXStart                dw       ; the pointer to the beginning of SFX
	PSGSFXPointer              dw       ; the pointer to the current address
	PSGSFXLoopPoint            dw       ; the pointer to the loop begin
	PSGSFXSkipFrames           db       ; the frames we need to skip
	PSGSFXLoopFlag             db       ; the SFX should loop or not (flag)
	; decompression vars for SFX
	PSGSFXSubstringLen         db       ; lenght of the substring we are playing
	PSGSFXSubstringRetAddr     dw       ; return to this address when substring is over
.ends
.define scrolls horizontalScroll
	
.enum $c100
	column.hasNewColumn db 
	column.columnAddress db
	column.buffer dsb VramRowCount*4
	
	palette.hasNewPalette db 
	palette.buffer dsb 32
.ende

.enum $c200
	tempVars db
.ende

.enum $c300
	vramRaw.haveData db
	vramRaw.destination dw
	vramRaw.fastOtirCall dw
	vramRaw.buffer dsb 256
.ende

.enum $c440
	spriteTable dsb 64
	spriteTableBottom dsb 128
.ende


.struct object
	objType db
	frameTimer db
	x db
	yFraction db
	y dw
	ySpeed dw
.endst

.enum $c500
	objectTable instanceOf object 32
.ende


.endif